using System;

namespace DarkStrideToolbox
{
	public enum enumStatus
	{
		Unknown,
		Online,
		Offline
	}

	[Serializable]
	public class User
	{
		#region Properties
		private string m_sSoftwareVersion = "";
		private DSSortedList m_oOtherVersions = new DSSortedList();
		private string m_sName = "";
		private string m_sIP = "";
		private long m_nPort = 0;
		private string m_sGUID = "";
		private DateTime m_nTimeOfLatestInfo = DateTime.MinValue;
		private string[] m_saBuddies = new string[ 0 ];
		private double m_nTimeOnline = 0;
		//An activity is what your currently hosting/joined to.  The data object is to be consumed by the same app that
		//populated it.  The key uniquely identifies the activity and the data gives further detail.
		//private string m_sActivityDesc = "";
		//private string m_sActivityKey = "";
		//private object m_oActivityData = null;
		private DSSortedList m_oUserActivity = new DSSortedList();

		[NonSerialized]
		private DateTime m_nTimeILastTriedToConnectedToThem = DateTime.MinValue; 
		[NonSerialized]
		private DateTime m_nTimeILoggedOn = DateTime.MinValue;

		private enumStatus m_oStatus = enumStatus.Unknown;
		private string m_sClientingToGUID = "";
		#endregion


		public User()
		{
		}


		//Calculate how long I've been online
		public void UpdateMyUser()
		{
			TimeSpan oDiff = TimeSpan.MinValue;

			//Update the time we were last updated
			this.TimeOfLatestInfo = DateTime.Now;

			//Update how long we've been online.  We do this instead of using a timestamp to avoid any time sync issues
			oDiff = DateTime.Now - this.TimeILoggedOn;
			this.TimeOnline = oDiff.TotalSeconds;
		}

		public void UpdateUserFrom( User oPendingUser )
		{
			m_sName						= oPendingUser.Name;
			m_sIP						= oPendingUser.IP;
			m_nPort						= oPendingUser.Port;
			m_sGUID						= oPendingUser.GUID;
			m_nTimeOfLatestInfo			= oPendingUser.TimeOfLatestInfo;
			m_saBuddies					= oPendingUser.Buddies;
			m_nTimeOnline				= oPendingUser.TimeOnline;
			//m_sActivityDesc				= oPendingUser.ActivityDesc;
			//m_sActivityKey				= oPendingUser.ActivityKey;
			//m_oActivityData				= oPendingUser.ActivityData;
			m_oUserActivity				= oPendingUser.UserActivity;
			m_oStatus					= oPendingUser.Status;
			m_sClientingToGUID			= oPendingUser.ClientingToGUID;
			m_sSoftwareVersion			= oPendingUser.SoftwareVersion;
			m_oOtherVersions			= oPendingUser.OtherVersions;
		}


		public override string ToString()
		{
			return( m_sName );
		}



		#region Properties
		public string Name
		{
			get
			{
				return( m_sName);
			}
			set
			{
				m_sName = value;
			}
		}
		public string IP
		{
			get
			{
				return( m_sIP );
			}
			set
			{
				m_sIP = value;
			}
		}
		public long Port
		{
			get
			{
				return( m_nPort );
			}
			set
			{
				m_nPort = value;
			}
		}
		public DateTime TimeOfLatestInfo
		{
			get
			{
				return( m_nTimeOfLatestInfo );
			}
			set
			{
				m_nTimeOfLatestInfo = value;
			}
		}
		public DateTime TimeILastTriedToConnectedToThem
		{
			get
			{
				return( m_nTimeILastTriedToConnectedToThem );
			}
			set
			{
				m_nTimeILastTriedToConnectedToThem = value;
			}
		}
		public enumStatus Status
		{
			get
			{
				return( m_oStatus );
			}
			set
			{
				m_oStatus = value;
			}
		}
		public string[] Buddies
		{
			get
			{
				return( m_saBuddies );
			}
			set
			{
				m_saBuddies = value;
			}
		}
		public string GUID
		{
			get
			{
				return( m_sGUID );
			}
			set
			{
				m_sGUID = value;
			}
		}
		public double TimeOnline
		{
			get
			{
				return( m_nTimeOnline );
			}
			set
			{
				m_nTimeOnline = value;
			}
		}
		public DateTime TimeILoggedOn
		{
			get
			{
				return( m_nTimeILoggedOn );
			}
			set
			{
				m_nTimeILoggedOn = value;
			}
		}

		public string ClientingToGUID
		{
			get
			{
				return( m_sClientingToGUID );
			}
			set
			{
				m_sClientingToGUID = value;
			}
		}

		public DSSortedList UserActivity
		{
			get
			{
				return( m_oUserActivity );
			}
			set
			{
				m_oUserActivity = value;
			}
		}
		public string SoftwareVersion
		{
			get
			{
				return( m_sSoftwareVersion ); 
			}
			set
			{
				m_sSoftwareVersion = value;
			}
		}
		public DSSortedList OtherVersions
		{
			get
			{
				return( m_oOtherVersions );
			}
			set
			{
				m_oOtherVersions = value;
			}
		}
		#endregion
	}

	[Serializable]
	public class UserActivity
	{
		#region Properties
		private string m_sDesc = "";
		private string m_sGUID = "";
		private object m_oData = null;
		#endregion

		public UserActivity()
		{
		}


		#region Properties
		public string Desc
		{
			get
			{
				return( m_sDesc );
			}
			set
			{
				m_sDesc = value;
			}
		}
		public string GUID
		{
			get
			{
				return( m_sGUID );
			}
			set
			{
				m_sGUID = value;
			}
		}
		public object Data
		{
			get
			{
				return( m_oData );
			}
			set
			{
				m_oData = value;
			}
		}
		#endregion
	}
}
